package org.jeecg.modules.system.job;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import lombok.extern.slf4j.Slf4j;
import org.jeecg.modules.system.entity.MxkOrganizations;
import org.jeecg.modules.system.entity.SysDepart;
import org.jeecg.modules.system.service.IMxkOrganizationsService;
import org.jeecg.modules.system.service.ISysDepartService;
import org.quartz.Job;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;
import org.springframework.beans.factory.annotation.Autowired;

import java.util.ArrayList;
import java.util.List;

/**
 * @Description: Maxkey部门同步任务
 *
 * @author: liaogui
 * @date: 2026年01月14日
 */
@Slf4j
public class MaxkeyDepartmentJob implements Job {
    @Autowired
    private IMxkOrganizationsService mxkOrganizationsService;

    @Autowired
    private ISysDepartService sysDepartService;

    @Override
    public void execute(JobExecutionContext jobExecutionContext) throws JobExecutionException {
        List<MxkOrganizations> list = mxkOrganizationsService.list(new LambdaQueryWrapper<MxkOrganizations>());
        List<SysDepart> sysDeparts = new ArrayList<>();
        list.forEach(mxkOrganizations -> {
            SysDepart depart = new SysDepart();
            depart.setId(mxkOrganizations.getId());
            if (!mxkOrganizations.getId().equals("1")) {
                depart.setParentId(mxkOrganizations.getParentid());
            }
            depart.setDepartName(mxkOrganizations.getFullname());
            depart.setOrgCode(mxkOrganizations.getOrgcode());
            depart.setDelFlag("0");
            sysDeparts.add(depart);
        });
        sysDepartService.saveOrUpdateBatch(sysDeparts);
        log.info("Maxkey部门同步任务执行成功");
    }
}
